<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ChannelSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = ['Sports', 'Movies', 'News', 'Entertainment'];
        
        for ($i = 1; $i <= 20; $i++) {
            \App\Models\Channel::create([
                'name' => "Channel $i",
                'line_a_url' => "http://stream-server.com/live/ch$i/index.m3u8",
                'line_b_url' => "http://backup-server.com/live/ch$i/index.m3u8",
                'current_line' => 'A',
                'status' => 'online',
                'category' => $categories[array_rand($categories)],
            ]);
        }
    }
}
