<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_preferences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->unique()->constrained('users')->cascadeOnDelete();

            // Sports
            $table->string('favorite_club')->nullable();     // النادي المفضل
            $table->string('favorite_sport')->nullable();    // الرياضة المفضلة

            // Entertainment
            $table->string('favorite_series')->nullable();   // المسلسل المفضل
            $table->string('favorite_star')->nullable();     // النجم المفضل
            $table->string('favorite_genre')->nullable();    // النوع المفضل (أكشن/رومانسي/...)
            $table->string('favorite_movie')->nullable();    // الفيلم المفضل

            // Location
            $table->string('country')->nullable();           // البلد
            $table->string('city')->nullable();              // المدينة

            // Notification preferences
            $table->boolean('notify_new_episodes')->default(true);
            $table->boolean('notify_live_matches')->default(true);
            $table->boolean('notify_new_movies')->default(true);
            $table->boolean('notify_subscription_expiry')->default(true);

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_preferences');
    }
};
