<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class UserPreference extends Model
{
    protected $fillable = [
        'user_id',
        'favorite_club',
        'favorite_sport',
        'favorite_series',
        'favorite_star',
        'favorite_genre',
        'favorite_movie',
        'country',
        'city',
        'notify_new_episodes',
        'notify_live_matches',
        'notify_new_movies',
        'notify_subscription_expiry',
    ];

    protected $casts = [
        'notify_new_episodes'       => 'boolean',
        'notify_live_matches'       => 'boolean',
        'notify_new_movies'         => 'boolean',
        'notify_subscription_expiry' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
