<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    /**
     * Admin: get all admin-level notifications
     */
    public function index()
    {
        return Notification::forAdmin()->latest()->limit(50)->get();
    }

    /**
     * User: get notifications for the authenticated user
     */
    public function userIndex(Request $request)
    {
        $notifications = Notification::forUser($request->user()->id)
            ->latest()
            ->limit(30)
            ->get();

        $unread = $notifications->where('is_read', false)->count();

        return response()->json([
            'notifications' => $notifications,
            'unread_count'  => $unread,
        ]);
    }

    public function markAsRead($id)
    {
        $notification = Notification::findOrFail($id);
        $notification->update(['is_read' => true]);
        return response()->json(['message' => 'تم تمييز التنبيه كمقروء']);
    }

    public function markAllRead(Request $request)
    {
        Notification::forUser($request->user()->id)->update(['is_read' => true]);
        return response()->json(['message' => 'تم تمييز جميع التنبيهات كمقروءة']);
    }

    public function markAllAsRead()
    {
        // Admin: mark all admin notifications as read
        Notification::forAdmin()->update(['is_read' => true]);
        return response()->json(['message' => 'تم تمييز جميع التنبيهات كمقروءة']);
    }

    public function destroy($id)
    {
        Notification::findOrFail($id)->delete();
        return response()->json(['message' => 'تم حذف التنبيه']);
    }
}
