<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Models\Series;
use Illuminate\Http\Request;

class SeriesController extends Controller
{
    public function index()
    {
        return Series::latest()->get();
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string',
            'url' => 'required|url',
            'description' => 'nullable|string',
            'category' => 'nullable|string',
            'poster_url' => 'nullable|url',
        ]);

        return Series::create($validated);
    }

    public function show(Series $series)
    {
        return $series;
    }

    public function update(Request $request, Series $series)
    {
        $validated = $request->validate([
            'title' => 'required|string',
            'url' => 'required|url',
            'description' => 'nullable|string',
            'category' => 'nullable|string',
            'poster_url' => 'nullable|url',
        ]);

        $series->update($validated);
        return $series;
    }

    public function destroy(Series $series)
    {
        $series->delete();
        return response()->json(null, 204);
    }
}
