<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ChannelController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return \Illuminate\Support\Facades\Cache::remember('channels_list', 60, function () {
            return \App\Models\Channel::all();
        });
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string',
            'line_a_url' => 'required|url',
            'line_b_url' => 'nullable|url',
            'category' => 'nullable|string',
        ]);

        return \App\Models\Channel::create($validated);
    }

    public function show(\App\Models\Channel $channel)
    {
        return $channel;
    }

    public function update(Request $request, \App\Models\Channel $channel)
    {
        $validated = $request->validate([
            'name' => 'sometimes|string',
            'line_a_url' => 'sometimes|url',
            'line_b_url' => 'nullable|url',
            'status' => 'sometimes|string',
            'category' => 'nullable|string',
        ]);

        $channel->update($validated);
        return $channel;
    }

    public function destroy(\App\Models\Channel $channel)
    {
        $channel->delete();
        return response()->noContent();
    }
}
