<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ActivationCodeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return \App\Models\ActivationCode::with('reseller')->latest()->get();
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'reseller_id' => 'required|exists:resellers,id',
            'type' => 'required|string',
            'count' => 'required|integer|max:100', // Bulk creation
        ]);

        $codes = [];
        for ($i = 0; $i < $validated['count']; $i++) {
            $codes[] = \App\Models\ActivationCode::create([
                'code' => strtoupper(\Illuminate\Support\Str::random(10)),
                'reseller_id' => $validated['reseller_id'],
                'status' => 'inactive',
                'type' => $validated['type'],
            ]);
        }

        return response()->json($codes, 201);
    }

    public function destroy(\App\Models\ActivationCode $activationCode)
    {
        $activationCode->delete();
        return response()->noContent();
    }
}
